#include "SolidObjects.h"
#include "CoordinateMapping.h"
#include <assert.h>

cSolidObjects::~cSolidObjects()
{
    int32_t i;
    for(i = 0; i != static_cast<int32_t>(_bufferPointers.size()); i += 2)
    {
        delete [] _bufferPointers[i];
    }
}

void
cSolidObjects::add(const std::vector<int32_t>& pointCoords)
{
    //assert(!pointCoords.empty());
    if(pointCoords.empty())
    {
        return;
    }
    int32_t* bufferStart = new int32_t [pointCoords.size()];
    int32_t* bufferEnd = bufferStart + pointCoords.size();
    _bufferPointers.push_back(bufferStart);
    _bufferPointers.push_back(bufferEnd);
    for(int32_t i = 0; i != static_cast<int32_t>(pointCoords.size()); ++i)
    {
        bufferStart[i] = pointCoords[i];
    }
}

void
cSolidObjects::applyCoordinateMapping(const cCoordinateMapping& mapping)
{
    for(int32_t i = 0; i != numberOfConvexSolids(); ++i)
    {
        for(int32_t j = 0; j != convexSolid_Points(i); ++j)
        {
            mapping.applyTo(_bufferPointers[i * 2] + j * 3);
        }
    }
}

// iSolidObjects interface

int32_t
cSolidObjects::numberOfConvexSolids() const
{
    return static_cast<int32_t>(_bufferPointers.size() / 2);
}
int32_t
cSolidObjects::convexSolid_Points(int32_t convexSolidIndex) const
{
    int32_t i = convexSolidIndex * 2;
    return static_cast<int32_t>((_bufferPointers[i + 1] - _bufferPointers[i]) / 3);
}
void
cSolidObjects::convexSolid_Point(int32_t convexSolidIndex, int32_t pointIndex, int32_t& x, int32_t& y, int32_t& z) const
{
    assert(convexSolidIndex >= 0 && convexSolidIndex < numberOfConvexSolids());
    assert(pointIndex >= 0 && pointIndex < convexSolid_Points(convexSolidIndex));
    const int32_t* bufferStart = _bufferPointers[convexSolidIndex * 2];
    const int32_t* point = bufferStart + pointIndex * 3;
    x = point[0];
    y = point[1];
    z = point[2];
}
int32_t
cSolidObjects::convexSolid_Attribute(int32_t, int32_t) const
{
    return -1;
}
